	function PLOT_STEP_RESPONSE_S(s_of_t, t_axis)
 
	%	Plots the step response of a causal analog filter 
	%	over the time interval given by t_axis.
 
	% Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% Author: 			Lars Wanhammar 2006-02-27
	% Modified by: 	 	
	% Copyright:		by authors - not released for commercial use
	% Version:			1 
	% Known bugs:	 
	% Report bugs to:	Wanhammar@gmail.com
	
	%========================================================	
	% Standard settings
	fs = 16; 		% Font size
	lw = 2; 		% Linewidth
	fn = 'times'; 	% Font
	%========================================================
	
	plot(t_axis, s_of_t, 'linewidth', lw);
	axis([0 t_axis(end) min(s_of_t)-0.1 max(s_of_t)+0.1]); %  This may be changed to get a neater plot
	ylabel('{\its}({\itt})','FontName', fn,'FontSize',fs);
	xlabel('{\itt} [s]','FontName', fn,'FontSize', fs);
	set(gca,'FontName', fn,'FontSize', fs);
	if (s_of_t(1) ~= 0)
		line([0 0],[0 s_of_t(1)], 'linewidth', lw)
	end
	hold on
	zoom on	
	grid on	
